<?php
// save_sms_result.php
header('Content-Type: application/json');
$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!empty($data) && isset($data['user_id']) && isset($data['results'])) {
    $user_id = $data['user_id'];
    $results = $data['results'];
    $save_path = 'data/' . $user_id . '_sms_results.json';
    
    $current_data = [];
    if (file_exists($save_path)) {
        $current_data = json_decode(file_get_contents($save_path), true);
        if (!isset($current_data['history'])) $current_data['history'] = [];
    }
    
    foreach ($results as $res) {
        $res['timestamp'] = date('Y-m-d H:i:s');
        array_unshift($current_data['history'], $res);
    }
    
    if (count($current_data['history']) > 50) {
        $current_data['history'] = array_slice($current_data['history'], 0, 50);
    }
    
    file_put_contents($save_path, json_encode($current_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
}
?>