<?php
header('Content-Type: application/json'); // پاسخ به صورت JSON

// اطمینان از اینکه درخواست POST است و deviceId ارسال شده
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['deviceId'])) {
    $deviceId = $_POST['deviceId'];
    $currentTime = time(); // زمان فعلی Unix timestamp

    $dataFilePath = 'data.json';

    // خواندن فایل JSON
    // استفاده از LOCK_EX برای جلوگیری از مشکلات همزمانی در نوشتن فایل
    $fileContent = file_get_contents($dataFilePath, FILE_SHARE_READ);
    $devices = json_decode($fileContent, true);

    if (!is_array($devices)) {
        $devices = []; // اگر فایل خالی یا خراب بود، آرایه خالی ایجاد کن
    }

    $found = false;
    foreach ($devices as &$device) { // استفاده از & برای ارجاع به المان برای تغییر
        if ($device['deviceId'] === $deviceId) {
            $device['lastSeen'] = $currentTime;
            $found = true;
            break;
        }
    }
    unset($device); // برای جلوگیری از side effect ها، ارجاع رو حذف کن

    // اگر دستگاه پیدا نشد، یک ورودی جدید اضافه کن
    if (!$found) {
        $devices[] = [
            'deviceId' => $deviceId,
            'lastSeen' => $currentTime
        ];
    }

    // نوشتن داده‌های به‌روز شده به فایل JSON
    if (file_put_contents($dataFilePath, json_encode($devices, JSON_PRETTY_PRINT), LOCK_EX)) {
        echo json_encode(['status' => 'success', 'message' => 'Status updated.']);
    } else {
        http_response_code(500); // Internal Server Error
        echo json_encode(['status' => 'error', 'message' => 'Failed to write to data file.']);
    }

} else {
    http_response_code(400); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'Invalid request. deviceId is required.']);
}
?>