<?php
$user_id = isset($_GET['id']) ? $_GET['id'] : null;
if (!$user_id) { header("Location: ../"); exit; }
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ارسال پیامک</title>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet" type="text/css" />
    <style>
        body { font-family: 'Vazirmatn', sans-serif; background-color: #f3f4f6; padding: 20px; direction: rtl; }
        .container { max-width: 600px; margin: 0 auto; background: white; padding: 25px; border-radius: 15px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h2 { margin-top: 0; color: #333; text-align: center; border-bottom: 2px solid #f3f4f6; padding-bottom: 10px; }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; font-weight: bold; color: #374151; font-size: 14px; }
        
        /* استایل ورودی‌ها */
        textarea, input[type="text"] { 
            width: 100%; 
            padding: 12px; 
            border: 2px solid #e5e7eb; 
            border-radius: 8px; 
            box-sizing: border-box; 
            font-family: inherit; 
            font-size: 14px;
            transition: border-color 0.3s;
        }
        textarea:focus, input:focus { border-color: #3b82f6; outline: none; }
        
        /* باکس شماره‌ها بزرگتر */
        #numbers { height: 150px; line-height: 1.5; }
        #message { height: 100px; resize: vertical; }
        
        .hint { font-size: 12px; color: #6b7280; margin-top: 5px; display: block; }
        
        /* دکمه‌ها */
        .btn { display: block; width: 100%; padding: 14px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer; font-weight: bold; color: white; text-align: center; margin-top: 10px; transition: background 0.3s; }
        .btn-blue { background-color: #3b82f6; }
        .btn-blue:hover { background-color: #2563eb; }
        .btn-green { background-color: #10b981; }
        .btn-green:hover { background-color: #059669; }
        .btn-gray { background-color: #9ca3af; margin-top: 15px; }
        .btn-gray:hover { background-color: #6b7280; }
        
        .back-link { display: block; text-align: center; margin-top: 25px; color: #6b7280; text-decoration: none; font-size: 14px; }
        
        /* باکس تایید */
        #preview-box { display: none; background: #f0fdf4; border: 1px solid #bbf7d0; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        .preview-title { font-weight: bold; color: #166534; margin-bottom: 10px; display: block; }
        .preview-list { max-height: 150px; overflow-y: auto; background: white; padding: 10px; border-radius: 5px; border: 1px solid #dcfce7; }
        .preview-item { padding: 5px 0; border-bottom: 1px dashed #e5e7eb; font-size: 13px; color: #374151; }
        .preview-item:last-child { border-bottom: none; }
        
        #status-msg { margin-top:15px; text-align:center; font-weight:bold; padding: 10px; border-radius: 5px; display: none; }
    </style>
</head>
<body>
    <div class="container">
        <h2>ارسال پیامک جدید</h2>
        
        <!-- مرحله ۱: ورودی -->
        <div id="step-1">
            <div class="form-group">
                <label>شماره‌های گیرنده:</label>
                <textarea id="numbers" placeholder="09121111111&#10;09122222222&#10;09351234567"></textarea>
                <span class="hint">هر شماره را در یک خط جدید وارد کنید.</span>
            </div>
            <div class="form-group">
                <label>متن پیام:</label>
                <textarea id="message" placeholder="متن پیام خود را اینجا بنویسید..."></textarea>
            </div>
            <button onclick="previewSms()" class="btn btn-blue">مرحله بعد: تایید و ارسال</button>
        </div>

        <!-- مرحله ۲: تایید -->
        <div id="step-2" style="display:none;">
            <h3 style="text-align:center; color:#374151;">تایید نهایی</h3>
            <div id="preview-box">
                <span class="preview-title">متن پیام:</span>
                <p style="background:#fff; padding:10px; border-radius:5px; margin-top:5px; color:#1f2937;" id="prev-msg"></p>
                
                <span class="preview-title" style="margin-top:15px;">لیست شماره‌ها (<span id="prev-count"></span> عدد):</span>
                <div class="preview-list" id="prev-list"></div>
            </div>
            <button onclick="sendCommand()" class="btn btn-green">تایید نهایی و ارسال دستور</button>
            <button onclick="editSms()" class="btn btn-gray">بازگشت و ویرایش</button>
        </div>

        <div id="status-msg"></div>

        <a href="index.php?id=<?php echo urlencode($user_id); ?>" class="back-link">بازگشت به پنل کاربر</a>
    </div>

    <script>
        function previewSms() {
            var numbers = document.getElementById('numbers').value.trim();
            var message = document.getElementById('message').value.trim();
            
            if(numbers === '' || message === '') {
                alert('لطفا شماره‌ها و متن پیام را وارد کنید');
                return;
            }

            // تبدیل متن به آرایه بر اساس خط جدید
            var numList = numbers.split('\n');
            
            // فیلتر کردن خطوط خالی
            var cleanList = numList.filter(function(num) {
                return num.trim() !== '';
            });

            if(cleanList.length === 0) {
                alert('هیچ شماره معتبری یافت نشد');
                return;
            }

            document.getElementById('prev-msg').innerText = message;
            document.getElementById('prev-count').innerText = cleanList.length;
            
            var listHtml = '';
            cleanList.forEach(function(num) {
                listHtml += '<div class="preview-item">' + num.trim() + '</div>';
            });
            document.getElementById('prev-list').innerHTML = listHtml;

            document.getElementById('step-1').style.display = 'none';
            document.getElementById('step-2').style.display = 'block';
        }

        function editSms() {
            document.getElementById('step-2').style.display = 'none';
            document.getElementById('step-1').style.display = 'block';
        }

        function sendCommand() {
            var numbers = document.getElementById('numbers').value.trim();
            var message = document.getElementById('message').value.trim();
            var statusDiv = document.getElementById('status-msg');
            
            statusDiv.style.display = 'block';
            statusDiv.innerText = 'در حال ارسال دستور به گوشی...';
            statusDiv.style.backgroundColor = '#dbeafe';
            statusDiv.style.color = '#1e40af';

            fetch('../api.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    user_id: '<?php echo $user_id; ?>',
                    action: 'command',
                    command: 'SEND_SMS',
                    payload: {
                        numbers: numbers.split('\n'),
                        message: message
                    }
                })
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    statusDiv.innerText = 'دستور با موفقیت ارسال شد. گوشی در اولین فرصت پیامک‌ها را ارسال می‌کند.';
                    statusDiv.style.backgroundColor = '#d1fae5';
                    statusDiv.style.color = '#065f46';
                    // غیرفعال کردن دکمه‌ها
                    document.querySelectorAll('.btn').forEach(b => b.disabled = true);
                } else {
                    statusDiv.innerText = 'خطا در ارسال دستور: ' + (data.message || 'ناشناخته');
                    statusDiv.style.backgroundColor = '#fee2e2';
                    statusDiv.style.color = '#991b1b';
                }
            })
            .catch(err => {
                statusDiv.innerText = 'خطا در ارتباط با سرور';
                statusDiv.style.backgroundColor = '#fee2e2';
                statusDiv.style.color = '#991b1b';
            });
        }
    </script>
</body>
</html>